<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt">

  <!-- Forming short list of occured repair errors from the source repair log -->
  <xsl:template name="CountErrors" match="/">
    <xsl:param name="Errors"></xsl:param>
    <xsl:for-each select="//Repair">
      <xsl:sort select="@type"/>
      <xsl:if test="not(@type = preceding::Repair/@type)">
        <xsl:variable name="type" select="@type"></xsl:variable>
        <xsl:if test="count($Errors//*[@Type = $type])">
          <Repair>
            <xsl:attribute name="Type">
              <xsl:value-of select="$type"/>
            </xsl:attribute>
            <xsl:attribute name="Count">
              <xsl:value-of select="count(//Repair[@type = current()/@type])"/>
            </xsl:attribute>
          </Repair>
        </xsl:if>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>

  <!-- generate group of repair errors: <Repair Type="..." Desc="..." Count="...".>-->
  <xsl:template name="GenGroup" match="/">
    <xsl:param name="Group"></xsl:param>
    <xsl:param name="Repair"></xsl:param>
    <xsl:for-each select="msxsl:node-set($Group)">
      <xsl:if test="name()='Repair'">
        <xsl:variable name="Type" select="@Type"></xsl:variable>
        <xsl:variable name="node" select="$Repair//*[name()='Repair' and @Type=$Type]"></xsl:variable>
        <Repair>
          <xsl:attribute name="Type">
            <xsl:value-of select="@Type"/>
          </xsl:attribute>
          <xsl:attribute name="Desc">
            <xsl:value-of select="@Desc"/>
          </xsl:attribute>
          <xsl:attribute name="Count">
            <xsl:choose>
              <!-- special case for count of 1XAgGap errors -->
              <xsl:when test="$Type='1XAgGap' and $node/@Count != 0 and $Repair//*[name()='Repair' and @Type='23SorAgImprovePS']/@Count != 9">
                <xsl:variable name="Count" select="$node/@Count + $Repair//*[name()='Repair' and @Type='23SorAgImprovePS']/@Count"></xsl:variable>
                <xsl:choose>
                  <xsl:when test="$Count!=0">
                    <xsl:value-of select="$Count"/>
                  </xsl:when>
                  <xsl:otherwise>
                    0
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>
              <xsl:otherwise>
                <xsl:choose>
                  <xsl:when test="$node/@Count!=0">
                    <xsl:value-of select="$node/@Count"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="0"/>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
        </Repair>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>

  <!-- generate summary table -->
  <xsl:template name="Stat" match="/">
    <xsl:param name="Root"></xsl:param>
    <xsl:param name="Repair"></xsl:param>
    <xsl:param name="Nesting"></xsl:param>
    <xsl:variable name="margin" select="$Nesting*20 + 5"></xsl:variable>
    <xsl:for-each select="$Root">
      <xsl:variable name="id" select="generate-id(node())"></xsl:variable>
      <xsl:choose>
        <xsl:when test="name()='Group'">
          <xsl:variable name="hasSubgr" select="count(node()[name()='Group'])!=0"></xsl:variable>
          <xsl:choose>
            
            <!-- show subgroup -->
            <xsl:when test="$hasSubgr=1">
              <tr>
                <td colspan="2" class="td_delimiter_dark"/>
              </tr>
              <tr class="tr_hover">
                <td colspan="2" class="td_dark">
                  <strong>
                    <xsl:attribute name="style">
                      <xsl:value-of select="concat('margin-left:', $margin, 'px')"/>
                    </xsl:attribute>
                    <xsl:value-of select="@Name"/>
                  </strong>
                </td>
              </tr>
              <xsl:call-template name="Stat">
                <xsl:with-param name="Root" select="node()"></xsl:with-param>
                <xsl:with-param name="Repair" select="$Repair"></xsl:with-param>
                <xsl:with-param name="Nesting" select="$Nesting + 1"></xsl:with-param>
              </xsl:call-template>
            </xsl:when>

            <!-- show list of errors -->
            <xsl:otherwise>
              <xsl:variable name="tmp">
                <xsl:call-template name="GenGroup">
                  <xsl:with-param name="Group" select="node()"></xsl:with-param>
                  <xsl:with-param name="Repair" select="$Repair"></xsl:with-param>
                </xsl:call-template>
              </xsl:variable>
              <xsl:variable name="Group" select="msxsl:node-set($tmp)"></xsl:variable>
              <xsl:variable name="Count" select="sum($Group/*/@Count)"></xsl:variable>
              <xsl:variable name="hasErrors" select="$Count != 0"></xsl:variable>
              <!-- group without any errors will be collapsed -->
              <tr>
                <td colspan="2" class="td_delimiter_light"/>
              </tr>
              <tr class="tr_hover">
                <td class="td_dark" colspan="2">
                  <strong>
                    <xsl:attribute name="style">
                      <xsl:value-of select="concat('margin-left:', $margin, 'px')"/>
                    </xsl:attribute>
                    <xsl:choose>
                      <xsl:when test="$hasErrors=0">
                        <a id="G_{$id}" class ="toggle" href="#" onclick="toggle('G{$id}', 'G_{$id}');return false;" title="Show">
                          + <xsl:value-of select="@Name"/>
                        </a>
                      </xsl:when>
                      <xsl:otherwise>
                        <a id="G_{$id}" class ="toggle" href="#" onclick="toggle('G{$id}', 'G_{$id}');return false;" title="Hide">
                          - <xsl:value-of select="@Name"/>
                          <!-- problems count: (<xsl:value-of select="$Count"/>) -->
                        </a>
                      </xsl:otherwise>
                    </xsl:choose>
                  </strong>
                </td>
              </tr>
              <tbody id="G{$id}">
                <xsl:variable name="margin2" select="($Nesting + 1)*20 + 5"></xsl:variable>
                <xsl:if test="$hasErrors=0">
                  <xsl:attribute name="style">display:none</xsl:attribute>
                </xsl:if>
                <xsl:for-each select="$Group/*">
                  <xsl:variable name="tdClass">
                    <xsl:choose>
                      <xsl:when test="(position() mod 2) != 1">
                          <xsl:text>td_dark</xsl:text>
                      </xsl:when>
                      <xsl:otherwise>
                          <xsl:text>td_light</xsl:text>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:variable>
                  <tr>
                    <td colspan="2" class="td_delimiter_light"/>
                  </tr>
                  <tr class="tr_hover">
                    <td class="td_light">
                      <div>
                        <xsl:attribute name="style">
                          <xsl:value-of select="concat('margin-left:', $margin2, 'px')"/>
                        </xsl:attribute>
                        <xsl:value-of select="@Desc"/>
                      </div>
                    </td>
                    <td class="td_light" align="right">
                      <xsl:text disable-output-escaping="yes"><![CDATA[&nbsp;]]></xsl:text>
                      <xsl:if test="@Count!=0">
                        <xsl:value-of select="@Count"/>
                      </xsl:if>
                      <xsl:text disable-output-escaping="yes"><![CDATA[&nbsp;]]></xsl:text>
                    </td>
                  </tr>
                </xsl:for-each>
              </tbody>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
      </xsl:choose>
    </xsl:for-each>
    <xsl:if test="$Nesting=0">
      <tr>
        <td colspan="2" class="td_delimiter_dark"/>
      </tr>
      <tr class="tr_hover">
        <td class="td_dark">
          <strong>
            Total:
          </strong>
        </td>
        <td class="td_dark" align="right">
          <strong>
            <xsl:value-of select="sum($Repair//*[name()='Repair']/@Count)"/>
          </strong>
        </td>
      </tr>
    </xsl:if>
  </xsl:template>

  <xsl:template match="/">
    <html>
      <head>
        <meta http-equiv="X-UA-Compatible" content="IE=8"/>
        <style type="text/css">
          body {
          font-family: Calibri, Verdana, Helvetica, sans-serif;
          font-size: 11pt;
          margin-left: 1em;
          }

          table {
          font-size: 11pt;
          margin-bottom: 1.5em;
          border-spacing: 0px;
          }
          
          table.table_block_1 {
          border: 1px solid #95bbca;
          width: 100%;
          }

          tr.tr_hover:hover td {
          background-color: #c7edfc;
          }

          td {
          background: #f9f9f9;
          border: 1px solid #dcdcdc;
          padding: 2px;
          font-size: 11pt;
          }
          
          td.td_header {
          background: #95bbca;
          color: white;
          border: 0px;
          height: 30px;
          padding-right: 5pt;
          padding-left: 5pt;
          }
          
          td.td_light {
          background: #fbfdff;
          border: 0px;
          padding: 5pt;
          }

          td.td_dark{
          background: #ecf9ff;
          border: 0px;
          padding: 5pt;
          }

          td.td_delimiter_dark {
          border: 0;
          border-bottom: 1pt solid #95bbca;
          padding:0;
          }
          
          td.td_delimiter_light {
          border: 0;
          border-bottom: 1pt solid #c7edfc;
          padding:0;
          }

          a.toggle {
          font-weight: bold;
          color: black;
          text-decoration: none;
          }

          div.hidden {
          display: none;
          }
        </style>
        <script type="text/javascript">
          <![CDATA[
          <!-- // toggle visibility -->
          function toggle(targetId, targetToggleId)
          {
          if(document.getElementById)
          {
          obj = document.getElementById(targetId);
          objToggle = document.getElementById(targetToggleId);
          if(obj.style.display == "none")
          {
          obj.style.display = "block";
          objToggle.title = "Hide";
          objToggle.innerHTML = "-" + objToggle.innerHTML.substring(1);
          }
          else
          {
          obj.style.display = "none";
          objToggle.title = "Show";
          objToggle.innerHTML = "+" + objToggle.innerHTML.substring(1);
          }
          }
          }
          ]]>
        </script>
      </head>

      <title>Repair Statistics</title>
      <body>
        <xsl:variable name="table" select="document('repair_errors_description.xml')"/>
        <xsl:variable name="Errors">
          <xsl:call-template name="CountErrors">
            <xsl:with-param name="Errors" select="$table/RepairErrors/*"></xsl:with-param>
          </xsl:call-template>
        </xsl:variable>
        <table class="table_block_1">
          <tr>
            <td class="td_header">
              <strong>Repair</strong>
            </td>
            <td class="td_header" align="right">
              <strong>Amount</strong>
            </td>
          </tr>
          <xsl:call-template name="Stat">
            <xsl:with-param name="Root" select="$table/RepairErrors/*"></xsl:with-param>
            <xsl:with-param name="Repair" select="msxsl:node-set($Errors)"></xsl:with-param>
            <xsl:with-param name="Nesting" select="0"></xsl:with-param>
          </xsl:call-template>
        </table>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
